﻿using System;
using System.Globalization;

namespace NVCC.Models
{
    [Serializable]
    public class DisclosedRadiologyReport
    {
        private const string DateFormat = "yyyyMMdd.HHmmss";
        public DisclosedRadiologyReport() { }
        public DisclosedRadiologyReport(RadiologyReport report)
        {
            RadiologyReportId = report.RadiologyReportId;
            ProcedureName = report.ProcedureName;

            if (report.ExamDateTime > DateTime.MinValue)
            {
                ExamDate = report.ExamDateTime;
            }
            else
            {
                const string twentyFour = "24";
                const string incorrectDecimals = ".240000";
                const string correctDecimals = ".235959";
                if (report.ExamDate.Substring(9, 2).Equals(twentyFour))
                {
                    report.ExamDate = report.ExamDate.Replace(incorrectDecimals, correctDecimals);
                }

                DateTime parsedDate;
                if (DateTime.TryParseExact(report.ExamDate, DateFormat, CultureInfo.InvariantCulture, DateTimeStyles.AllowWhiteSpaces, out parsedDate))
                {
                    ExamDate = parsedDate;
                }
                else
                {
                    ExamDate = report.ExamDateTime;
                }
            }
        }
        public long DisclosedRadiologyReportId { get; set; }
        public int DisclosureId { get; set; }
        public string RadiologyReportId { get; set; }
        public string ProcedureName { get; set; }
        public DateTime ExamDate { get; set; }
    }
}
